@props(['priority'])

@php
$classes = match ($priority) {
    'high' => 'bg-red-100 text-red-700 dark:bg-red-900/50 dark:text-red-300 border border-red-200 dark:border-red-800',
    'medium' => 'bg-yellow-100 text-yellow-700 dark:bg-yellow-900/50 dark:text-yellow-300 border border-yellow-200 dark:border-yellow-800',
    'low' => 'bg-green-100 text-green-700 dark:bg-green-900/50 dark:text-green-300 border border-green-200 dark:border-green-800',
    default => 'bg-gray-100 text-gray-700 dark:bg-gray-900/50 dark:text-gray-300 border border-gray-200 dark:border-gray-800',
};
@endphp

<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $classes }}">
    {{ ucfirst($priority) }}
</span>
