<?php

namespace App\Http\Middleware;

use App\Models\Tenant;
use Closure;
use Illuminate\Http\Request;

class ResolveTenantMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $tenantParam = $request->route('tenant');

        if ($tenantParam) {
            $tenant = Tenant::where('subdomain', $tenantParam)->first();

            if ($tenant) {
                // Set tenant information for the request
                $tenant->makeCurrent();
            }
        }

        return $next($request);
    }
}
