<?php

namespace App\Livewire\Tenant\Template;

use App\Traits\WhatsApp;
use Livewire\Component;

class TemplateList extends Component
{
    use WhatsApp;

    public function mount()
    {
        if (! checkPermission('tenant.template.view')) {
            $this->notify(['type' => 'danger', 'message' => t('access_denied_note')], true);

            return redirect()->to(tenant_route('tenant.dashboard'));
        }
    }

    public function loadTemplate()
    {
        if (checkPermission('tenant.template.load_template')) {
            try {
                $response = $this->loadTemplatesFromWhatsApp();
                $this->notify([
                    'message' => $response['message'],
                    'type' => $response['status'] ? 'success' : 'danger',
                ]);

                $this->dispatch('pg:eventRefresh-whatspp-template-table-sgz2iu-table', [], 'window');
            } catch (\Exception $e) {
                whatsapp_log('Error loading WhatsApp templates: '.$e->getMessage(), 'error', [
                    'file' => $e->getFile(),
                    'line' => $e->getLine(),
                ], $e);

                $this->notify([
                    'message' => t('template_load_failed').': '.$e->getMessage(),
                    'type' => 'danger',
                ]);
            }
        }
    }

    public function refreshTable()
    {
        $this->dispatch('pg:eventRefresh-whatspp-template-table-sgz2iu-table');
    }

    public function render()
    {
        return view('livewire.tenant.template.template-list');
    }
}
