<?php

namespace App\Observers;

use App\Facades\AdminCache;
use App\Models\Page;

class PageObserver
{
    public function saved(Page $page)
    {
        $this->clearCache();
    }

    public function deleted(Page $page)
    {
        $this->clearCache();
    }

    private function clearCache()
    {
        // Clear navigation and page related caches
        AdminCache::invalidateTags(['admin.navigation', 'model.page', 'frontend.menu']);
    }
}
