import "./bootstrap";
import "./config";
import "@nextapps-be/livewire-sortablejs";
import "./../../vendor/power-components/livewire-powergrid/dist/powergrid";
import flatpickr from "flatpickr";
import "flatpickr/dist/flatpickr.css";
import "./tippy";
import GLightbox from "glightbox";

// Store the lightbox instance globally
window.GLightboxInstance = null;

// Define a global function to initialize GLightbox
window.initGLightbox = function () {
    // Destroy previous instance if it exists
    if (window.GLightboxInstance) {
        window.GLightboxInstance.destroy();
    }

    // Create new instance
    window.GLightboxInstance = GLightbox({
        selector: ".glightbox",
        touchNavigation: true,
        loop: true,
        zoomable: true,
        autoplayVideos: true,
    });
};

// Initialize once on DOM ready
document.addEventListener("DOMContentLoaded", function () {
    window.initGLightbox();
});

