<div {!! $attributes !!}>
    <div class="sm:hidden">
        <x-dropdown width="full" align="top">
            <x-slot:trigger>
                <button type="button"
                    class="relative w-full cursor-default rounded-md border border-slate-300 bg-white py-2 pl-3 pr-10 text-left shadow-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:text-sm dark:border-slate-600 dark:bg-slate-700 dark:text-slate-200 dark:focus:ring-offset-slate-800">
                    @if (request()->routeIs('admin.themes.settings.view'))
                        {{ t('theme') }}
                    @elseif(request()->routeIs('admin.section-title.settings.view'))
                        {{ t('section_title_subltitle') }}
                    @elseif(request()->routeIs('admin.hero-section.settings.view'))
                        {{ t('hero_section') }}
                    @elseif(request()->routeIs('admin.partner-logo.settings.view'))
                        {{ t('partner_logo') }}
                    @elseif(request()->routeIs('admin.unique-feature.settings.view'))
                        {{ t('unique_feature') }}
                    @elseif(request()->routeIs('admin.feature.settings.view'))
                        {{ t('feature') }}
                    @elseif(request()->routeIs('admin.testimonials.settings.view'))
                        {{ t('testimonials') }}
                    @elseif(request()->routeIs('admin.website-seo.settings.view'))
                        {{ t('website_seo_og') }}
                    @elseif(request()->routeIs('admin.custom-css.settings.view'))
                        {{ t('custom_css') }}
                    @elseif(request()->routeIs('admin.custom-js.settings.view'))
                        {{ t('custom_js') }}
                    @else
                        {{ t('please_select_an_option') }}
                    @endif
                    <span class="pointer-events-none absolute inset-y-0 right-0 ml-3 flex items-center pr-3">
                        <x-heroicon-m-chevron-up-down class="h-5 w-5 text-slate-400" />
                    </span>
                </button>
            </x-slot:trigger>
            <x-slot:content>
                <x-dropdown-link href="{{ route('admin.themes.settings.view') }}">
                    {{ t('theme') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.section-title.settings.view') }}">
                    {{ t('section_title_subltitle') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.hero-section.settings.view') }}">
                    {{ t('hero_section') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.partner-logo.settings.view') }}">
                    {{ t('partner_logo') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.unique-feature.settings.view') }}">
                    {{ t('unique_feature') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.feature.settings.view') }}">
                    {{ t('feature') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.testimonials.settings.view') }}">
                    {{ t('testimonials') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.website-seo.settings.view') }}">
                    {{ t('website_seo_og') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.custom-css.settings.view') }}">
                    {{ t('custom_css') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ route('admin.custom-js.settings.view') }}">
                    {{ t('custom_js') }}
                </x-dropdown-link>
            </x-slot:content>
        </x-dropdown>
    </div>

    <div class="hidden sm:block">
        <div class="bg-white ring-1 ring-slate-300 sm:rounded-lg dark:bg-transparent dark:ring-slate-600 p-4">
            <div>
                <nav class="flex flex-col gap-1 justify-start" aria-label="Tabs" wire:ignore>

                    <a href="{{ route('admin.themes.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.themes.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.themes.settings.view'),
                    ])>
                        <x-heroicon-o-paint-brush class="w-6 h-6 md:flex-none" />
                        <span>{{ t('theme') }}</span>
                    </a>

                    <a href="{{ route('admin.section-title.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.section-title.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.section-title.settings.view'),
                    ])>
                        <x-heroicon-o-pencil-square class="w-6 h-6 md:flex-none" />
                        <span>{{ t('section_title_subltitle') }}</span>
                    </a>

                    <a href="{{ route('admin.hero-section.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.hero-section.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.hero-section.settings.view'),
                    ])>
                        <x-heroicon-o-rocket-launch class="w-6 h-6 md:flex-none" />
                        <span>{{ t('hero_section') }}</span>
                    </a>

                    <!-- SupportAgent -->
                    <a href="{{ route('admin.partner-logo.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.partner-logo.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.partner-logo.settings.view'),
                    ])>
                        <x-heroicon-o-building-office-2 class="w-6 h-6" />
                        <span>{{ t('partner_logo') }}</span>
                    </a>

                    <a href="{{ route('admin.feature.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b  font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.feature.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.feature.settings.view'),
                    ])>
                        <x-heroicon-o-star class="w-6 h-6" />
                        <span>{{ t('feature') }}</span>
                    </a>

                    <a href="{{ route('admin.unique-feature.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b  font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.unique-feature.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.unique-feature.settings.view'),
                    ])>
                        <x-heroicon-o-sparkles class="w-6 h-6" />
                        <span>{{ t('unique_feature') }}</span>
                        
                    </a>

                    <a href="{{ route('admin.testimonials.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.testimonials.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.testimonials.settings.view'),
                    ])>

                        <x-heroicon-o-chat-bubble-left-right class="w-6 h-6" />
                        <span>{{ t('testimonials') }}</span>
                    </a>

                    <a href="{{ route('admin.website-seo.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.website-seo.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.website-seo.settings.view'),
                    ])>

                        <x-heroicon-o-globe-alt class="w-6 h-6" />
                        <span>{{ t('website_seo_og') }}</span>
                    </a>

                    <a href="{{ route('admin.custom-css.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.custom-css.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.custom-css.settings.view'),
                    ])>

                        <x-carbon-color-palette class="w-6 h-6" />
                        <span>{{ t('custom_css') }}</span>
                    </a>

                    <a href="{{ route('admin.custom-js.settings.view') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'admin.custom-js.settings.view'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'admin.custom-js.settings.view'),
                    ])>

                        <x-heroicon-s-code-bracket class="w-6 h-6" />
                        <span>{{ t('custom_js') }}</span>
                    </a>

                </nav>
            </div>
        </div>
    </div>

</div>