@props(['collapsed' => false])

@php
$user = auth()->user();
@endphp

<x-admin.sidebar-layout :collapsed="$collapsed">
    {{-- Dashboard --}}
    <x-admin.sidebar-navigation-item route="admin.dashboard" icon="heroicon-o-squares-2x2" class="w-5 h-5 mr-2"
        :label="t('dashboard')" :tooltip="t('dashboard')" :collapsed="$collapsed" />

    {{-- Tenant Section --}}
    @if(checkPermission('admin.tenants.view'))
    <x-admin.sidebar-expandable-section :title="t('tenant')" icon="heroicon-o-building-office-2" :collapsed="$collapsed"
        section-id="tenant" :default-expanded="true">

        <x-admin.sidebar-navigation-item route="admin.tenants.list" class="w-5 h-5 mr-2" :label="t('tenants')"
            :tooltip="t('tenants')" permission="admin.tenants.view"
            :badge="get_new_tenants_count() > 0 ? get_new_tenants_count() : null" :collapsed="$collapsed" />
    </x-admin.sidebar-expandable-section>
    @endif

    {{-- Sales Section --}}
    @if (checkPermission(['admin.subscription.view', 'admin.invoices.view', 'admin.transactions.view']))
    <x-admin.sidebar-expandable-section :title="t('sales')" :collapsed="$collapsed" icon="heroicon-o-credit-card"
        section-id="sales" :default-expanded="true">

        <x-admin.sidebar-navigation-item route="admin.subscription.list" class="w-5 h-5 mr-2" :label="t('subscription')"
            :tooltip="t('subscription')" permission="admin.subscription.view" :collapsed="$collapsed" />

        <x-admin.sidebar-navigation-item route="admin.invoices.list" class="w-5 h-5 mr-2" :label="t('invoices')"
            :tooltip="t('invoices')" permission="admin.invoices.view" :collapsed="$collapsed" />

        <x-admin.sidebar-navigation-item route="admin.transactions.index" class="w-5 h-5 mr-2"
            :label="t('transactions')" :tooltip="t('transactions')" permission="admin.transactions.view"
            :badge="get_new_transactions_count() > 0 ? get_new_transactions_count() : null" :collapsed="$collapsed" />

        @if($user->is_admin === true && $user->user_type === 'admin')
        <x-admin.sidebar-navigation-item route="admin.credit-management.list" class="w-5 h-5 mr-2"
            :label="t('credit_management')" :tooltip="t('credit_management')" :collapsed="$collapsed" />
        @endif
    </x-admin.sidebar-expandable-section>
    @endif

    {{-- Plans Section --}}
    @if (checkPermission('admin.plans.view'))
    <x-admin.sidebar-expandable-section :title="t('plans')" :collapsed="$collapsed" icon="carbon-plan"
        section-id="plans" :default-expanded="true">

        <x-admin.sidebar-navigation-item route="admin.plans.list" class="w-5 h-5 mr-2" :label="t('plans')"
            :tooltip="t('plans')" permission="admin.plans.view" :collapsed="$collapsed" />
    </x-admin.sidebar-expandable-section>
    @endif



    {{-- Tickets --}}
    <x-admin.sidebar-expandable-section :title="t('support')" :collapsed="$collapsed" icon="heroicon-o-ticket"
        section-id="ticket" :default-expanded="true">

        <x-admin.sidebar-navigation-item route="admin.tickets.index" class="w-5 h-5 mr-2" :label="t('tickets')"
            :tooltip="t('tickets')" :collapsed="$collapsed" />
    </x-admin.sidebar-expandable-section>

    {{-- Whatsapp Webhook --}}
    @if($user->is_admin === true && $user->user_type === 'admin')
    <x-admin.sidebar-expandable-section :title="t('whatsapp_webhook')" :collapsed="$collapsed" icon="carbon-webhook"
        section-id="ticket" :default-expanded="true">

        <x-admin.sidebar-navigation-item route="admin.whatsapp-webhook" class="w-5 h-5 mr-2"
            :label="t('whatsapp_webhook')" :tooltip="t('whatsapp_webhook')" :collapsed="$collapsed" />
    </x-admin.sidebar-expandable-section>
    @endif

    {{-- Settings Section --}}
    @if (checkPermission(['admin.payment_settings.view', 'admin.website_settings.view', 'admin.system_settings.view']))
    <x-admin.sidebar-expandable-section :title="t('settings')" :collapsed="$collapsed"
        icon="heroicon-o-wrench-screwdriver" section-id="users" :default-expanded="false">

        {{-- Payment settings --}}
        <x-admin.sidebar-navigation-item route="admin.payment-settings" class="w-5 h-5 mr-2"
            :label="t('payment_settings')" :tooltip="t('payment_settings')" permission="admin.payment_settings.view"
            :collapsed="$collapsed" />
        <!-- WhatsMark Settings -->
        <x-admin.sidebar-navigation-item route="admin.themes.settings.view" :route-names="[
        'admin.themes.settings.view',
        'admin.section-title.settings.view',
        'admin.hero-section.settings.view',
        'admin.partner-logo.settings.view',
        'admin.unique-feature.settings.view',
        'admin.feature.settings.view',
        'admin.testimonials.settings.view',
        'admin.website-seo.settings.view',
        'admin.custom-css.settings.view',
        'admin.custom-js.settings.view',
    ]" :label="t('website_settings')" class="w-5 h-5 mr-2" :tooltip="t('website')"
            permission="admin.website_settings.view" :collapsed="$collapsed" />


        {{-- System-settings --}}
        <x-admin.sidebar-navigation-item route="admin.system.settings.view" :route-names="[
        'admin.system.settings.view',
        'admin.email.settings.view',
        'admin.re-captcha.settings.view',
        'admin.cron-job.settings.view',
        'admin.announcement.settings.view',
        'admin.system-update.settings.view',
        'admin.system-information.settings.view',
        'admin.cache-management.settings.view',
        'admin.tenant-settings.settings.view',
    ]" :label="t('system_settings')" class="w-5 h-5 mr-2" :tooltip="t('system')"
            permission="admin.system_settings.view" :collapsed="$collapsed" />

    </x-admin.sidebar-expandable-section>

    @endif

    {{-- Setup Button --}}
    <button x-on:click.prevent="setupMenu = true"
        class="group  items-center hidden lg:flex px-4 py-2 text-sm font-medium rounded-r-md text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white mt-2 w-full">
        <x-heroicon-o-cog-6-tooth data-tippy-content="{{ t('setup') }}" data-tippy-placement="right"
            class="mr-4 flex-shrink-0 h-6 w-6 text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300"
            aria-hidden="true" />
        <span class="whitespace-nowrap" x-show="!isCollapsed" x-transition:enter.duration.700ms>{{ t('setup') }}</span>
    </button>

    {{-- Setup Button --}}
    <button x-on:click.prevent="mobileOpen = true"
        class="group lg:hidden flex items-center px-4 py-2 text-sm font-medium rounded-r-md text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white mt-2 w-full">
        <x-heroicon-o-cog-6-tooth data-tippy-content="{{ t('setup') }}" data-tippy-placement="right"
            class="mr-4 flex-shrink-0 h-6 w-6 text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300"
            aria-hidden="true" />
        <span class="whitespace-nowrap" x-show="!isCollapsed" x-transition:enter.duration.700ms>{{ t('setup') }}</span>
    </button>

    {{-- Mobile Setup Menu Slot --}}
    @slot('mobileSetupMenu')
    <!-- Users -->
    <x-admin.sidebar-navigation-item route="admin.users.list" icon="heroicon-o-users" class="w-5 h-5 mr-2"
        :label="t('user')" permission="admin.users.view" />

    <!-- Roles -->
    @if ($user->is_admin === true && $user->user_type === 'admin')
    <x-admin.sidebar-navigation-item route="admin.roles.list" icon="heroicon-o-swatch" class="w-5 h-5 mr-2"
        :label="t('role')" permission="admin.roles.view" />
    @endif

    <!-- Department -->
    @if (module_exists('Tickets') && module_enabled('Tickets'))
    <x-admin.sidebar-navigation-item route="admin.department.list" icon="heroicon-o-briefcase" class="w-5 h-5 mr-2"
        :label="t('department')" permission="admin.department.view" />
    @endif

    <!-- Languages -->
    @if ($user->is_admin === true && $user->user_type === 'admin')
    <x-admin.sidebar-navigation-item route="admin.languages" icon="heroicon-s-language" class="w-5 h-5 mr-2"
        :label="t('languages')" />
    @endif

    <!-- Theme -->
    <x-admin.sidebar-navigation-item route="admin.theme" icon="heroicon-o-paint-brush" class="w-5 h-5 mr-2"
        :label="t('theme')" />

    <!-- Currencies -->
    <x-admin.sidebar-navigation-item route="admin.currencies.manage" icon="heroicon-o-currency-dollar"
        class="w-5 h-5 mr-2" :label="t('currencies')" permission="admin.currency.view" />

    <!-- Taxes -->
    @if($user->is_admin === true && $user->user_type === 'admin')
    <x-admin.sidebar-navigation-item route="admin.taxes.manage" icon="heroicon-o-receipt-percent" class="w-5 h-5 mr-2"
        :label="t('taxes')" />
    @endif

    <!-- FAQs -->
    <x-admin.sidebar-navigation-item route="admin.faqs" icon="carbon-question-answering" class="w-5 h-5 mr-2"
        :label="t('faq')" permission="admin.faq.view" />

    <!-- Pages -->
    <x-admin.sidebar-navigation-item route="admin.pages" icon="carbon-white-paper" class="w-5 h-5 mr-2"
        :label="t('pages_sidebar')" permission="admin.pages.view" />

    <!-- Email Templates -->
    <x-admin.sidebar-navigation-item route="admin.email-template.list" icon="heroicon-o-envelope" class="w-5 h-5 mr-2"
        :label="t('email_templates')" permission="admin.email_template.view" />

    <!-- System Logs -->
    @if (module_exists('LogViewer') && module_enabled('LogViewer') && $user->is_admin === true && $user->user_type ===
    'admin')
    <x-admin.sidebar-navigation-item route="admin.logs.index" icon="heroicon-o-document-text" class="w-5 h-5 mr-2"
        :label="t('system_logs')" />
    @endif

    <!-- Modules -->
    @if ($user->is_admin === true && $user->user_type === 'admin')
    <x-admin.sidebar-navigation-item route="admin.modules.index" icon="heroicon-o-puzzle-piece" class="w-5 h-5 mr-2"
        :label="t('modules')" />
    @endif
    @endslot
</x-admin.sidebar-layout>