<div class="mx-auto">
    <x-slot:title>
        {{ t('tenant_settings') }}
    </x-slot:title>
    <!-- Page Heading -->
    <div class="flex justify-between">
        <div class="pb-6">
            <x-settings-heading>{{ t('system_settings') }}</x-settings-heading>
        </div>
    </div>
    <div class="flex flex-wrap lg:flex-nowrap gap-4">
        <!-- Sidebar Menu -->
        <div class="w-full lg:w-1/5">
            <x-admin-system-settings-navigation wire:ignore />
        </div>

        <div class="flex-1 space-y-5">
            <form wire:submit="save" class="space-y-6" x-data="{ 'isRegistrationEnable': @entangle('isRegistrationEnabled'), 'isVerificationEnabled': @entangle('isVerificationEnabled') }">
                <x-card class="rounded-lg shadow-sm border border-slate-200 dark:border-slate-700">
                    <x-slot:header class="pb-3 border-b border-slate-200 dark:border-slate-700">
                        <x-settings-heading class="text-xl font-semibold text-slate-900 dark:text-white">
                            {{ t('allow_tenant_registration') }}
                        </x-settings-heading>
                        <x-settings-description class="mt-1 text-sm text-slate-500 dark:text-slate-400">
                            {{ t('enable_or_disable_public_tenant_registration_if_disabled') }}
                        </x-settings-description>
                    </x-slot:header>
                    <x-slot:content class="space-y-4 py-5">
                        <!-- Registration Toggle -->
                        <div
                            class="p-4 transition duration-150 rounded-md hover:bg-slate-50 dark:hover:bg-slate-800/50">
                            <div class="flex items-center justify-between">
                                <div class="flex items-start gap-3">
                                    <div class="flex-shrink-0 mt-0.5">
                                        <x-heroicon-o-user-plus class="h-6 w-6 text-indigo-500" />
                                    </div>
                                    <div class="flex-1">
                                        <h3 class="text-sm font-medium text-slate-900 dark:text-white">
                                            {{ t('enable_registration') }}</h3>
                                        <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">
                                            {{ t('allow_new_tenants_to_register_on_your_platform') }}</p>
                                    </div>
                                </div>
                                <div>

                                    <button type="button" x-on:click="isRegistrationEnable = !isRegistrationEnable"
                                        class="relative inline-flex flex-shrink-0 h-6 w-11 border-2 border-transparent rounded-full cursor-pointer transition-colors ease-in-out duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-slate-800"
                                        :class="isRegistrationEnable ? 'bg-indigo-600' : 'bg-slate-200 dark:bg-slate-700'"
                                        role="switch" :aria-checked="isRegistrationEnable">
                                        <span class="sr-only">{{ t('toggle_switch') }}</span>
                                        <span aria-hidden="true"
                                            class="pointer-events-none inline-block h-5 w-5 rounded-full bg-white shadow transform ring-0 transition ease-in-out duration-200"
                                            :class="isRegistrationEnable ? 'translate-x-5' : 'translate-x-0'">
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Email Verification Toggle -->
                        <div
                            class="p-4 transition duration-150 rounded-md hover:bg-slate-50 dark:hover:bg-slate-800/50">
                            <div class="flex items-center justify-between">
                                <div class="flex items-start gap-3">
                                    <div class="flex-shrink-0 mt-0.5">
                                        <x-carbon-security class="h-6 w-6 text-indigo-500" />

                                    </div>
                                    <div class="flex-1">
                                        <h3 class="text-sm font-medium text-slate-900 dark:text-white">
                                            {{ t('enable_email_verification') }}</h3>
                                        <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">
                                            {{ t('require_email_verification_before_tenants_can_access_their_accounts') }}
                                        </p>
                                    </div>
                                </div>
                                <div>
                                    <button type="button" x-on:click="isVerificationEnabled = !isVerificationEnabled"
                                        class="relative inline-flex flex-shrink-0 h-6 w-11 border-2 border-transparent rounded-full cursor-pointer transition-colors ease-in-out duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-slate-800"
                                        :class="isVerificationEnabled ? 'bg-indigo-600' : 'bg-slate-200 dark:bg-slate-700'"
                                        role="switch" :aria-checked="isVerificationEnabled">
                                        <span class="sr-only">{{ t('toggle_switch') }}</span>
                                        <span aria-hidden="true"
                                            class="pointer-events-none inline-block h-5 w-5 rounded-full bg-white shadow transform ring-0 transition ease-in-out duration-200"
                                            :class="isVerificationEnabled ? 'translate-x-5' : 'translate-x-0'">
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </x-slot:content>
                    @if(checkPermission('admin.system_settings.edit'))
                    <x-slot:footer
                        class="bg-slate-50 dark:bg-slate-800/50 px-4 py-3 border-t border-slate-200 dark:border-slate-700 flex justify-end">
                        <x-button.loading-button type="submit" target="save">
                            {{ t('save_changes') }}
                        </x-button.loading-button>
                    </x-slot:footer>
                    @endif
                </x-card>
            </form>
        </div>
    </div>
</div>
