<div class="relative" x-init="getObserver()">
    <x-slot:title>
        {{ t('whatsapp_template') }}
    </x-slot:title>

    <div class="flex flex-col sm:flex-row justify-start items-start lg:items-center gap-2 mb-4">
        @if (get_tenant_setting_from_db('whatsapp', 'is_whatsmark_connected') != 0)
        @if (checkPermission('tenant.template.load_template'))
        <x-button.loading-button type="button" target="loadTemplate" wire:click="loadTemplate"
            class="whitespace-nowrap px-4 py-2">
            {{ t('load_template') }}
        </x-button.loading-button>
        @endif
        @endif

        <a href="https://business.facebook.com/wa/manage/message-templates/" target="_blank" rel="noopener noreferrer">
            <x-button.primary class="whitespace-nowrap px-4 py-2">
                {{ t('template_management') }}
            </x-button.primary>
        </a>
    </div>

    <x-card class="rounded-lg">
        <x-slot:content>
            <div class="lg:mt-0" wire:poll.30s="refreshTable">
                <livewire:tenant.tables.whatspp-template-table />
            </div>
        </x-slot:content>
    </x-card>
</div>
