<x-guest-layout class="p-2">
    <div class="min-h-screen flex flex-col items-center bg-gray-100 dark:bg-slate-900">
        <div class="max-w-6xl p-6 mx-4 lg:mx-auto bg-white dark:bg-slate-800 rounded-lg shadow-md">
            <div class="mb-6">
                <h1 class="text-2xl font-semibold text-slate-700 dark:text-slate-300">{{ $title }}
                </h1>
                @if ($updated_at)
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-2">Last updated:
                        {{ $updated_at }}</p>
                @endif
            </div>
            <hr class="mb-3">
            <div class="prose dark:prose-invert max-w-none mb-2">
                {!! $content !!}
            </div>

            <x-button.primary onclick="window.history.back()">
                Back
            </x-button.primary>
        </div>
    </div>
</x-guest-layout>
