import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import path from "path";
import fs from "fs";
import collectModuleAssetsPaths from "./vite-module-loader.js";

const themeFilePath = path.resolve(__dirname, "theme.json");
const activeTheme = fs.existsSync(themeFilePath)
    ? JSON.parse(fs.readFileSync(themeFilePath, "utf8")).name
    : "anchor";
console.log(`Active theme: ${activeTheme}`);

export default defineConfig(async () => {
    // Collect module asset paths
    let moduleAssets = [];
    try {
        moduleAssets = await collectModuleAssetsPaths([], "Modules");
    } catch (error) {
        console.warn("Failed to load module assets:", error.message);
    }

    const inputFiles = [
        "resources/css/app.css",
        "resources/css/admin-app.css",
        "resources/css/tenant-app.css",
        "resources/js/app.js",
        "resources/js/admin-app.js",
        "resources/js/tenant-app.js",
        ...moduleAssets, // Add module assets
    ];

    return {
        plugins: [
            laravel({
                input: inputFiles,
                refresh: true,
            }),
        ],
        server: {
            cors: true,
        },
        refresh: [`resources/themes/${activeTheme}/**/*`],
        build: {
            chunkSizeWarningLimit: 1000, // Increased from default 500kb to 1000kb to avoid warnings
        },
    };
});
